require( "scripts/style.lua" );

MedalFontColor = {
  standardFont,
  13,
  BlackColor
};

MedalFontGray = {
  standardFont,
  13,
  GrayColor,
};

xbase = 50;
ybase = 50;
xgap = 75;
ygap = 75;

function xprint( ... ) 
  local out = ":::::::::: "; 
  table.foreachi( arg, 
		function(i, value) 
			out = out .. tostring(value) 
		end 
  ); 
  DebugOut( out ); 
end

function Award(ptable)
	-- xprint("00 PTABLE is ", ptable);
	return function()
		-- xprint("01 PTABLE is ", ptable);
		local gtable = 
		{
			x = 0, --xbase + ptable[1] * xgap,
			y = 0, --ybase + ptable[2] * ygap,
			

			flags = kVAlignCenter + kHAlignCenter,
			--command = function()
			--	SendAwardMessage(ptable[3]);
			--end;
		};
		
		if game:HasAward(ptable[3]) then
			gtable.image = "awards/"..ptable[3].."_color";
			gtable.mask = exists("awards/"..ptable[3].."_color.mask.png");
			gtable.graphics = 
			{
				"awards/"..ptable[3].."_color",
			};
		else
			gtable.graphics = { "awards/"..ptable[3].."_gray", };
			gtable.image = "awards/"..ptable[3].."_gray";
			gtable.mask = exists("awards/"..ptable[3].."_gray.mask.png");
		end;
	
		
		--gtable.typename='tDFButton';
		gtable.typename='Bitmap';
		DoWindow( gtable );
		
		local medaltext = 
		{
			font = MedalFontGray,
			flags = kVAlignTop + kHAlignCenter, 
			x = ptable[1], y = ptable[2], w = 93, h = 40,
			label=ptable[3].."_title",
		};
		
		if game:HasAward(ptable[3]) then
			medaltext.font = MedalFontColor;
		end
		
		medaltext.typename='Text';
		DoWindow( medaltext );
		
	end; -- function end
end; -- award end

function UpdateSubmit()
	DebugOut("UpdateSubmit()");
	DebugOut("CANSUBMIT =" .. tostring(cansubmit));
	
	local localHS = IsEnabled(kHiscoreLocalOnly);
	DebugOut("LOCALHS =" .. tostring(localHS));
	
	local anonHS = IsEnabled(kHiscoreAnonymous);
	DebugOut("ANONHS =" .. tostring(anonHS));
		
	local fullHS = (not localHS) and (not anonHS);
	DebugOut("FULLHS =" .. tostring(fullHS));
	
	local nummedals = NumMedalsToSubmit();
	DebugOut("NumMedalsToSubmit =" .. tostring(nummedals));

	local result = 	cansubmit and fullHS and (nummedals > 0);
	DebugOut("DECISION =" .. tostring(result));
	
	EnableWindow('submit', result);
	EnableWindow('resubmit', fullHS and nummedals == 0 and NumEarnedMedals() > 0);
	
	-- EnableWindow('submit', true);	 -- for testing
end

BACKBUTTONSPEC =
	{
		font = StandardButtonFont,
		x = 200,
		y = kMax - 50,
		align = kVAlignBottom + kHAlignRight,
		label = "awards_back",
		command = function() PopModal("awards") end;
	};
	
ADVENTUREBUTTONSPEC =
	{
		font = SmallButtonFont,
		x = kCenter,
		y = kMax - 42,
		align = kVAlignBottom + kHAlignRight,
		label = "awards_activity",
		command = function() EnableWindow("adventure", false); EnableWindow("activity", true); end;
	};
	
ACTIVITYBUTTONSPEC =
	{
		font = SmallButtonFont,
		x = kCenter,
		y = kMax - 42,
		align = kVAlignBottom + kHAlignRight,
		label = "awards_adventure",
		command = function() EnableWindow("adventure", true); EnableWindow("activity", false); end;
	};

SUBMITBUTTONSPEC = 
		{
			font = StandardButtonFont,
			x = kMax - 90,
			y = kMax - 50,
			name="submit",
			type = kPush,
			align = kVAlignBottom + kHAlignRight,
			label="submit",
			command =
				function()
					vars = loadstring(GetLuaServerSubmitSetupVars(true));
					vars();
					val = DoModal("scripts/serversubmit.lua");
					if (val == 'success') then
						DisplayDialog {
							"scripts/ok.lua",
							body ="medalsuccess",
							title = ""
						};
					end
					UpdateSubmit();
				end
		};
		
RESUBMITBUTTONSPEC = 
		{
			font = StandardButtonFont,
			x = kMax - 90,
			y = kMax - 50,
			name="resubmit",
			type = kPush,
			align = kVAlignBottom + kHAlignRight,
			label="resubmit",
			command =
				function()
					vars = loadstring(GetLuaServerSubmitSetupVars(true));
					vars();
					val = DoModal("scripts/serversubmit.lua");
					if (val == 'success') then
						DisplayDialog {
							"scripts/ok.lua",
							body ="medalsuccess",
							title = ""
						};
					end
					UpdateSubmit();
				end
		};


AWARDSPEC =
{
	image = "backgrounds/fullscreendialog",
	mask = exists("backgrounds/fullscreendialog.mask.png"),
	alpha = true,
	x = kCenter,
	y = kCenter,

	-- right side page
	--[[
	Window
	{
		x = 480, y = 75,
		w = 350, h = kMax,

		Text 
		{
			font = DialogTitleFont,
			x = kCenter, y = 20, w = kMax, h = 40,
			flags = kVAlignTop + kHAlignCenter, 
			name = "item_title",
		},

		Text 
		{
			font = PopupFont,
			x = kCenter, y = 60, w = kMax, h = kMax,
			flags = kVAlignTop + kHAlignCenter, 
			name = "item_body",
		},
	},
	--]]

	-- left side page (inside cover)
	tAwardsWindow
	{
		x = 0, y = 0,
		w = kMax, h = kMax,

		Text 
		{
			font = DialogTitleFont,
			x = kCenter, y = 40, w = kMax, h = 40,
			flags = kVAlignTop + kHAlignCenter, 
			label = "awards_list_header", 
			name = "awards_list_header",
		},
		
		Window
		{
			name="adventure";
			w = kMax,
			h = kMax,
			Award { 148, 145, "avenue-flo_weddingdress" },
			Award { 286, 145, "avenue-flo_snookums" },
			Award { 424, 145, "avenue-flo_weddingcake" },
			Award { 569, 145, "avenue-flo_bouquets" },
			Award { 148, 333, "avenue-flo_butterflies" },
			Award { 290, 333, "avenue-flo_recycle" },
			Award { 430, 333, "avenue-flo_weddingrings" },
			Award { 575, 333, "avenue-flo_finish" },
			
			SetStyle( ActivityButtonStyle ),
			Button(ADVENTUREBUTTONSPEC);
		},
		
		Window
		{
			name="activity";
			w = kMax,
			h = kMax,
			Award { 150, 155, "avenue-flo_beadingmaster" },
			Award { 346, 150, "avenue-flo_clothingdisplay" },
			Award { 552, 150, "avenue-flo_packaging" },
			Award { 150, 350, "avenue-flo_chickenchaser" },
			Award { 350, 340, "avenue-flo_chickenconductor" },
			Award { 552, 340, "avenue-flo_doughballwrangler" },
			
			SetStyle( ActivityButtonStyle ),
			Button(ACTIVITYBUTTONSPEC);
		}
	},
	
	
	-- BACK button
	SetStyle( ChangePlayerButtonStyle ),
	Button(BACKBUTTONSPEC),
	
	Button(SUBMITBUTTONSPEC);
	Button(RESUBMITBUTTONSPEC);
};

MakeDialog
{
	-- Name the modal dialog
	name = "awards",
	alpha = true,
	Window
	{
		alpha = true,
		x = 0, y = 0, w = kMax, h = kMax, 
		speed_in = slide_speed_in, speed_out = slide_speed_out, accel_in = slice_accel_in, accel_out = slide_accel_out,
		Bitmap(AWARDSPEC),
	}
} -- MakeDialog

UpdateSubmit();	 -- before showing it, decide if we can submit...

EnableWindow("activity", false);